const StaffRole = require("../models/staffRoleModel");

exports.getAllRoles = async (req, res) => {
  try {
    const roles = await StaffRole.find();
    res
      .status(200)
      .json({ status: "success", results: roles.length, data: { roles } });
  } catch (err) {
    res.status(400).json({ status: "fail", message: err.message });
  }
};

exports.createRole = async (req, res) => {
  try {
    const newRole = await StaffRole.create(req.body);
    res.status(201).json({ status: "success", data: { role: newRole } });
  } catch (err) {
    res.status(400).json({ status: "fail", message: err.message });
  }
};

exports.updateRole = async (req, res) => {
  try {
    const role = await StaffRole.findByIdAndUpdate(req.params.id, req.body, {
      new: true,
      runValidators: true,
    });
    res.status(200).json({ status: "success", data: { role } });
  } catch (err) {
    res.status(400).json({ status: "fail", message: err.message });
  }
};

exports.deleteRole = async (req, res) => {
  try {
    await StaffRole.findByIdAndDelete(req.params.id);
    res.status(204).json({ status: "success", data: null });
  } catch (err) {
    res.status(400).json({ status: "fail", message: err.message });
  }
};
